{
This program shows you an image, asks you if you want to keep it and, 
if yes, renumbers them continually in the output folder.

Program DO NOT require initialization file


The input parameters requested from operator:

- 'Select IMAGE for size definition' --> enter the file header 
- Browse and select directory where images are stored
- 'Enter the FILE HEADER' --> enter the file header convention <FILE HEADER><_><Index>.tif
- 'Enter the FIRST frame' --> enter the index number for start
- 'Enter the LAST frame' --> enter the index number for end

- 'Enter the NUMBER of LOOPS' 	   --> number of circles of rejection 
- 'Enter the REJECTION CRITERIA'   --> rejection criteria in sigmas 
- 'Enter the REJECTION TRESHOLD'   --> threshold for saturated pixels or 
  		 	 		   			   	   pixels with anomalously high amplitude

All averaged and standard deviation images stored for each loop
Naming convention for output files:
<File header><"_"><av><loop index> 	--> averaged file
<File header><"_"><sd><loop index>	--> standard deviation file

Usually the last averaged file is used for further processing
									   
Created by Vladimir Lobastov 13.01.2002}



const
  	 	  CommonDlgsLib = 'VppCommonDlgs.dll' ;	 	{DLL for common dialog} 
		  InPath='D:\Data\UED4_Data_processed\';			 	{default path for images}
		  Path2='D:\\Data\UED4_Data_processed\Utilities_UED4\';		{default path for initial mask image}
		  Qwst='Do you want to use Patch for saturated pixels?';
		  		  
		  function BrowseFolders( Path:pointer ) : integer ; external CommonDlgsLib ;
		  

var 
	


{************************************************************************}
{ ***	                      Function FieldedFileName 				  ***}									   
{************************************************************************}


function FieldedFileName(FName, ind);
  begin
    FieldedFileName:= FName+'_'+ReplaceStr(Str(ind:4),' ','0',rs_ReplaceAll);		//Attach the index count (with leading zeros) to the file name 
  end; 
	


Procedure SetRegion(var L,T,R,B;Left,Top,Right,Bottom);								//Equate four variables
begin
   L:=Left;
   T:=Top;
   R:=Right;
   B:=Bottom;
end;
  
  
{************************************************************************}
{ ***	                      Function GetFolder	   				  ***}									   
{************************************************************************}

  
function GetFolder( InitPath ) ;
{ Opens the folder browse dialog and returns a folder path }
{ InitPath may be used to set the initial folder (set to '' otherwise) }
{ Returns a null string if Cancel is pressed }

const
  BufSize = 255 ;
  
var
  FolderName ;

begin
  FolderName := InitPath + StringOfChar( ' ',BufSize - Length( InitPath ) ) ;		//Initialize the variable Folder Name
  if BrowseFolders( FolderName ) <> 0 then 			   		   			  	 		//If a folder is selected
    GetFolder := Trim( FolderName )	  												//Return the folder path
else
    GetFolder := '' ;			  													//Return the Null String
end;  { GetFolder }

{------------------------------------>end of Function --GetFolder--}  	

{
 ************************************************************************
 ************************************************************************
 ***                                                                  ***
 ***	                      Main program							  ***
 ***																  ***
 ************************************************************************ 
 ************************************************************************
}

var
   	Img, Image, ROIImage, ROI;				//Image variables
	xyCoor;									//ROI array
	xSize,ySize;
	RLeft,RTop,RRight,RBottom;				//ROI coordinate variables
	mean;									//mean count
	ind, new_ind;							//indices
	i, j;									//string varialbes of indices
	F,N;		  							//first and last number of images to process
	FHead;	  								//file header
	Path, Output;							//path for images
	TRlow, TRup;							//lower and upper intensity threshold
	bg;
  
begin
		F:=1;								//the first frame to process
		N:=100;								//the last frame to process
		FHead:='Xe';					    //file header
		TRup:=500;							//upper threshold for rejection
		TRlow:=40;				 			//lower threshold for rejection
		new_ind:= 1;						//new index label 
				
                           
 

				
		
				   		  Path:=GetFolder( InPath )+'\';	  	  			  								  //Use the default directory or select a new one
                		  if ( Path = '\' ) then halt( 'Directory not selected' ) ;
				   	 	  WriteInfo(Path);					   
                          GetString('Enter the FILE HEADER',FHead);									  //Display a dialog box and prompt the user to enter a string
						  GetNumber('Enter the FIRST frame',F);						  				  //Display a dialog box and prompt the user to enter a number
						  GetNumber('Enter the LAST frame',N);				   
						  GetNumber('Enter the LOWER Display Treshold',TRlow);		
						  GetNumber('Enter the UPPER Display Treshold',TRup);			
						 
						 
  

begin


  	   	  				   
{---->}	for ind:=F to N do	   
		   begin
			   i:=FieldedFileName('',ind);  										//Convert expression (ind) to a string (with leading zeros)
   			   CreateDir(Path + 'KeepImage'); 										//create subdirectory for output
			   Open(Path+FHead+i+'.tif',Image);										//Read the ith sample image from disk
			   GetXYSize( Image,xSize,ySize );
               ROI   := CreateImage( typ_Word, xSize,ySize ) ;  					//Create a new image with same size 
			   ROI:=Image;		 	 		   			   	 						//Copy the contents 
			   Show(ROI);
	//		   Show(Image) ;
			   SetDisplayZoom(ROI,25);	
			   FitInWindow( ROI ) ;								
			   SetWindowPos( ROI , 0, 0 );
			   SetDisplayRange(ROI, TRlow, TRup );								//Set the display range for the combo image
	//		   Show(Image) ;

			   bg:=Query( 'Do you want to keep image # '+i+'?' );
 			   if bg = id_Yes then
   	 		   begin
							j:=FieldedFileName('',new_ind);  						//Convert expression (new_ind) to a string (with leading zeros)
							Save(Image, Path + 'KeepImage\'+FHead+j+'.tif');		//Save the jth sample image in the output directory
							new_ind := new_ind + 1 ;   	   	 			  	  		//Increment the new index by one
							Free(j); 												//Free the string j		
	 		   end;
			   

			   Free(i); 															//Free the string i		   					
			   end  ;
			   
			   
			   
	
		
		
		PlaySound( 'C:\Program Files\Digital Optics\V++\Library\Mac.wav' ) ;	 		 //Play a sound
		WriteInfo('Processing completed!!!');							   				 //Display a message in the status bar

end;
end
